package gov.va.med.domain.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;


/** 
 *        @hibernate.class
 *         table="PATIENTS"
 *     
*/
public class Patient extends User {

    /** nullable persistent field */
    private Long cmorInstitutionId;

    /** persistent field */
    private Set patient;

    /** persistent field */
    private Set institutions;
    
    private HealthRecords healthRecords;

    /** default constructor */
    public Patient() {
    }

    /** 
     *            @hibernate.property
     *             column="INSTITUTION_ID"
     *             length="20"
     *         
     */
    public Long getCmorInstitutionId() {
        return this.cmorInstitutionId;
    }

    public void setCmorInstitutionId(Long institutionId) {
        this.cmorInstitutionId = institutionId;
    }

    /** 
     *            @hibernate.set
     *             lazy="true"
     *             inverse="true"
     *             cascade="none"
     *            @hibernate.collection-key
     *             column="USER_ID_SEQ"
     *            @hibernate.collection-key
     *             column="ICN"
     *            @hibernate.collection-one-to-many
     *             class="gov.va.med.domain.model.Patient"
     *         
     */
    public Set getInstitutions() {
        return this.institutions;
    }

    public void setInstitutions(Set institutions) {
        this.institutions = institutions;
    }

    public String toString() {
        return new ToStringBuilder(this)
            .append(super.toString())
            .append("createdDate", getCreatedDate())
            .append("modifiedDate", getModifiedDate())
            .append("cmorInstitutionId", getCmorInstitutionId())
            .append("icn", getIcn())
            .toString();
    }

    public boolean equals(Object other) {
        if ( (this == other ) ) return true;
        if ( !(other instanceof Patient) ) return false;
        Patient castOther = (Patient) other;
        return new EqualsBuilder()
            .append(this.getId(), castOther.getId())
            .append(this.getCreatedDate(), castOther.getCreatedDate())
            .isEquals();
    }

    
    public String getIcn() {
    	return this.icn;
    }
    public void setIcn(String icn) {
        this.icn = icn;
    }

    public Set getPatient() {
        return patient;
    }
    

    public void setPatient(Set patient) {
        this.patient = patient;
    }

    public HealthRecords getHealthRecords() {
        return healthRecords;
    }
    

    public void setHealthRecords(HealthRecords healthRecords) {
        this.healthRecords = healthRecords;
    }
    
    /**
     * Special setter that initializes sparesly populated Institutions
     * from station numbers. 
     */
    public void setInstitutionsFromStationNumbers(
									String [] stations) {
        
        setInstitutions(new HashSet(stations.length));
        for (int i = 0; i < stations.length ; i++) {
		    if (stations[i] != null) {   //protective code - entries may be null! 
			    getInstitutions().add(
			        new Institution(stations[i]));	
			}
		} 
	}
    //  **** Non Hibernate code begins here:
    private String cmorStationNumber;
    public void setCmorStationNumber(String value) { cmorStationNumber = value;}
    public String getCmorStationNumber()           { return cmorStationNumber; }
    public Institution getInstitutionByInstitutionId(long institutionId)
    {
    	if (institutions==null)
    		return null;
    	for (Iterator iter=institutions.iterator();iter.hasNext();)
    	{
    		Institution facility = (Institution)(iter.next());
    		if (facility.getLongId()==institutionId)
    			return facility;
    		
    	}
    	return null;
    }
 }
    


